IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_NF_ENT_CANCELAMENTO]') AND type in (N'P', N'PC'))
	BEGIN
		DROP PROCEDURE [dbo].[P_EST_NF_ENT_CANCELAMENTO]
	END
	
	
GO

CREATE PROCEDURE P_EST_NF_ENT_CANCELAMENTO (@CD_EMP INT, @CD_FILIAL INT, @CD_NF INT)
AS
	BEGIN TRY
		
		BEGIN TRANSACTION
		
		DECLARE @CD_MT_CANCEL	INT		
		DECLARE	@CD_USU			INT
		DECLARE @DT_CANCEL		DATETIME
		DECLARE @ST_DENEGADA	INT
		DECLARE	@DT_ATUAL		DATETIME
		
		DECLARE @RS_CD_PROD		INT		
		DECLARE @RS_CD_NT_MOV	INT
		DECLARE @RS_CD_IT		INT
		DECLARE @RS_QT_IT		MONEY
				
		DECLARE @RS_CD_VD		INT
		DECLARE @RS_CD_CTR		INT
		
		SET @DT_ATUAL = CONVERT(VARCHAR(10), GETDATE(), 101)
		
		------------------------------------------------------------------------------------------------------------
		PRINT 'Obtendo informacoes sobre quem solicitou o cancelamento'
		------------------------------------------------------------------------------------------------------------
		SELECT 
			@CD_MT_CANCEL	= T.CD_MT_CANCEL,
			@CD_USU			= T.CD_USU,
			@DT_CANCEL		= T.DT_CANCEL,
			@ST_DENEGADA	= T.ST_DENEGADA
		FROM EST_NF_ENT_CANCEL_SOLIC T
		WHERE	T.CD_EMP		= @CD_EMP
				AND T.CD_FILIAL	= @CD_FILIAL
				AND T.CD_NF		= @CD_NF 
				

		------------------------------------------------------------------------------------------------------------
		PRINT 'Marcando a nota fiscal como cancelada'
		------------------------------------------------------------------------------------------------------------
		UPDATE EST_NF_ENT SET 
			STS_NF		= (CASE WHEN @ST_DENEGADA = 1 THEN 3 ELSE 1 END), 			
			CD_USU		= @CD_USU,
			DT_ULT_ALT	= @DT_CANCEL,
			CD_MT_CANCEL= @CD_MT_CANCEL
		WHERE CD_EMP		= @CD_EMP 
			AND CD_FILIAL	= @CD_FILIAL
			AND CD_NF		= @CD_NF
	


		------------------------------------------------------------------------------------------------------------
		PRINT 'Gravando informacoes do cancelamento/denegacao'
		------------------------------------------------------------------------------------------------------------
		INSERT INTO EST_NF_ENT_CANCEL (CD_EMP, CD_FILIAL, CD_NF, CD_USU, DT_CANCEL, DT_CAD)
							VALUES	  (@CD_EMP, @CD_FILIAL, @CD_NF, ISNULL(@CD_USU,1), @DT_CANCEL, @DT_ATUAL)
			

		IF @ST_DENEGADA > 0
			BEGIN 
				INSERT INTO EST_NF_ENT_DENEGADA (CD_EMP, CD_FILIAL, CD_NF, DT_DENEGADA, DT_CAD)
									VALUES		(@CD_EMP, @CD_FILIAL, @CD_NF, @DT_CANCEL, @DT_ATUAL)
			END					
							
		------------------------------------------------------------------------------------------------------------
		PRINT 'Voltando o estoque dos itens da nota fiscal'
		------------------------------------------------------------------------------------------------------------					
		DECLARE RS_TEMP_IT CURSOR FAST_FORWARD FOR 
			SELECT
				i.CD_PROD,
				i.QT_IT,
				n.CD_NT_MOV
			FROM
				EST_NF_ENT_IT i INNER JOIN EST_NF_ENT n ON
				i.CD_EMP = n.CD_EMP AND
				i.CD_FILIAL = n.CD_FILIAL AND
				i.CD_NF = n.CD_NF AND
				i.DT_ENT = n.DT_ENT
			WHERE
				i.CD_EMP		= @CD_EMP
				AND i.CD_FILIAL = @CD_FILIAL
				AND i.CD_NF		= @CD_NF
				
		OPEN RS_TEMP_IT
		FETCH NEXT FROM RS_TEMP_IT INTO @RS_CD_PROD, @RS_QT_IT, @RS_CD_NT_MOV
			WHILE @@FETCH_STATUS=0
				BEGIN			    
					EXEC P_EST_PROD_CPL_ESTOQUE_MOVIMENTACAO @CD_EMP, @CD_FILIAL, @RS_CD_PROD, @RS_CD_NT_MOV, @RS_QT_IT, 1
					
					FETCH NEXT FROM RS_TEMP_IT INTO @RS_CD_PROD, @RS_QT_IT, @RS_CD_NT_MOV
				END
				
		CLOSE RS_TEMP_IT;
		DEALLOCATE RS_TEMP_IT;							
				

		------------------------------------------------------------------------------------------------------------
		PRINT 'Excluindo cancelamento de TEF da devolucao da venda'
		------------------------------------------------------------------------------------------------------------
		DELETE D 
		FROM     
			PDV_VD_EST_NF_ENT 
			INNER JOIN PDV_VD_CANCEL_TEF D ON	
				PDV_VD_EST_NF_ENT.CD_EMP 	= D.CD_EMP AND
				PDV_VD_EST_NF_ENT.CD_FILIAL = D.CD_FILIAL AND 
				PDV_VD_EST_NF_ENT.CD_VD 	= D.CD_VD
		WHERE 
				PDV_VD_EST_NF_ENT.CD_EMP 		= @CD_EMP 
				AND PDV_VD_EST_NF_ENT.CD_FILIAL = @CD_FILIAL 
				AND PDV_VD_EST_NF_ENT.CD_NF 	= @CD_NF 
    
		------------------------------------------------------------------------------------------------------------
		PRINT 'Excluindo cancelamento de Convenio da devolucao da venda'
		------------------------------------------------------------------------------------------------------------
		SELECT 
			@RS_CD_VD = PDV_VD_EST_NF_ENT.CD_VD, 
			@RS_CD_CTR = ISNULL(PDV_VD_RC_VD_CONV.CD_CTR,0)
    
		FROM PDV_VD_EST_NF_ENT 
			INNER JOIN PDV_VD_CANCEL_CONV ON 
				PDV_VD_EST_NF_ENT.CD_EMP = PDV_VD_CANCEL_CONV.CD_EMP AND
				PDV_VD_EST_NF_ENT.CD_FILIAL = PDV_VD_CANCEL_CONV.CD_FILIAL AND 
				PDV_VD_EST_NF_ENT.CD_VD = PDV_VD_CANCEL_CONV.CD_VD 			
			INNER JOIN PDV_VD_RC_VD_CONV ON 
				PDV_VD_EST_NF_ENT.CD_EMP = PDV_VD_RC_VD_CONV.CD_EMP AND
				PDV_VD_EST_NF_ENT.CD_FILIAL = PDV_VD_RC_VD_CONV.CD_FILIAL AND 
				PDV_VD_EST_NF_ENT.CD_VD = PDV_VD_RC_VD_CONV.CD_VD 
    
		WHERE 
			PDV_VD_EST_NF_ENT.CD_EMP 		= @CD_EMP
			AND PDV_VD_EST_NF_ENT.CD_FILIAL = @CD_FILIAL 
			AND PDV_VD_EST_NF_ENT.CD_NF 	= @CD_NF 
		
		IF @RS_CD_VD > 0 	
			BEGIN
				DELETE D
				FROM PDV_VD_CANCEL_CONV D
				WHERE 
					D.CD_EMP = @CD_EMP
					AND D.CD_FILIAL = @CD_FILIAL
					AND D.CD_VD = @RS_CD_VD 
					
					
				UPDATE T SET 
					ST_FECHVD_CONV = 0
				FROM RC_VD_CONV T
				WHERE 
					T.CD_EMP = @CD_EMP
					AND T.CD_FILIAL = @CD_FILIAL
					AND T.CD_CTR = @RS_CD_CTR 
			END
			
		------------------------------------------------------------------------------------------------------------
		PRINT 'Excluindo cancelamento de Duplicata da devolucao da venda'
		------------------------------------------------------------------------------------------------------------						
		DELETE D
		FROM 
			PDV_VD_EST_NF_ENT
			INNER JOIN PDV_VD_CANCEL_DUP D ON    
				PDV_VD_EST_NF_ENT.CD_EMP 	= D.CD_EMP AND
				PDV_VD_EST_NF_ENT.CD_FILIAL = D.CD_FILIAL AND 
				PDV_VD_EST_NF_ENT.CD_VD 	= D.CD_VD
		WHERE 
			PDV_VD_EST_NF_ENT.CD_EMP 		= @CD_EMP 
			AND PDV_VD_EST_NF_ENT.CD_FILIAL = @CD_FILIAL 
			AND PDV_VD_EST_NF_ENT.CD_NF 	= @CD_NF 
	
    	
		------------------------------------------------------------------------------------------------------------
		PRINT 'Removendo vinculo com nota fiscal de entrada'
		------------------------------------------------------------------------------------------------------------
		DELETE FROM EST_PROD_IMP_EST_NF_ENT
		WHERE	CD_EMP		  = @CD_EMP 
				AND CD_FILIAL = @CD_FILIAL	
				AND CD_NF 	  = @CD_NF

		------------------------------------------------------------------------------------------------------------
		PRINT 'Relatando nota fiscal com status de denegada'
		------------------------------------------------------------------------------------------------------------
		INSERT INTO PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT_DENEGADA (CD_EMP, CD_FILIAL, CD_VD, CD_IMP, CD_PROD, CD_NF, CD_IT)
		SELECT I.CD_EMP, I.CD_FILIAL, I.CD_VD, I.CD_IMP, I.CD_PROD, I.CD_NF, I.CD_IT 
		FROM PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT	I			
			INNER JOIN EST_NF_ENT_DENEGADA D ON 
				I.CD_EMP = D.CD_EMP
				AND I.CD_FILIAL = D.CD_FILIAL 
				AND I.CD_NF = D.CD_NF				
		WHERE	I.CD_EMP		  = @CD_EMP 
				AND I.CD_FILIAL	  = @CD_FILIAL	
				AND I.CD_NF 	  = @CD_NF	
				
		------------------------------------------------------------------------------------------------------------
		PRINT 'Removendo vinculo com nota fiscal de entrada'
		------------------------------------------------------------------------------------------------------------
		DELETE FROM PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT				
		WHERE	CD_EMP		  = @CD_EMP 
				AND CD_FILIAL = @CD_FILIAL	
				AND CD_NF 	  = @CD_NF	
				
	
		------------------------------------------------------------------------------------------------------------
		PRINT 'Marcando a nota fiscal como pendencia que nao sera solucionada'
		------------------------------------------------------------------------------------------------------------
		UPDATE T SET 
			PEND_SOLUC = 2
		FROM EST_NF_ENT_NFE_PEND T 
		WHERE 
			T.CD_EMP			= @CD_EMP
			AND T.CD_FILIAL		= @CD_FILIAL
			AND T.CD_NF			= @CD_NF
			AND T.PEND_SOLUC	= 1						
		
		------------------------------------------------------------------------------------------------------------
		PRINT 'Deletando pendcia de cancelamento automatico.'
		------------------------------------------------------------------------------------------------------------		
		DELETE D
		FROM EST_NF_ENT_CANCEL_PEND D
		WHERE 
			D.CD_EMP		= @CD_EMP		
			AND D.CD_FILIAL = @CD_FILIAL 
			AND D.CD_NF		= @CD_NF 
		
		
		COMMIT TRANSACTION
END	TRY
BEGIN CATCH
	ROLLBACK TRANSACTION 
	
	DECLARE @ErrorMessage NVARCHAR(4000);
    DECLARE @ErrorSeverity INT;
    DECLARE @ErrorState INT;

    SELECT 
        @ErrorMessage = ERROR_MESSAGE(),
        @ErrorSeverity = ERROR_SEVERITY(),
        @ErrorState = ERROR_STATE();
    
    RAISERROR (@ErrorMessage,@ErrorSeverity,@ErrorState);
END CATCH 	
